
#ifndef _BUTTON_H_
#define _BUTTON_H_

#include "ht32f520xx_01.h"

#define  _BUTTON1_   13 	  /* PC13 */																					
#define  _BUTTON2_	 10     /* PC10 */			
#define  _BUTTON3_	 12     /* PC12 */			
#define  _BUTTON4_	 11     /* PC11 */

#define  BUTTON1_State	8																	
#define  BUTTON2_State	4
#define  BUTTON3_State	2
#define  BUTTON4_State	1

#define  BUTTON1_PORT		HT_GPIOC																						
#define	 BTN1_PORT_NUM	GPIO_PC
#define  BUTTON2_PORT 	HT_GPIOC
#define	 BTN2_PORT_NUM	GPIO_PC
#define  BUTTON3_PORT 	HT_GPIOC
#define	 BTN3_PORT_NUM	GPIO_PC
#define  BUTTON4_PORT 	HT_GPIOC
#define	 BTN4_PORT_NUM	GPIO_PC

#define	BUTTON1_IN	(BUTTON1_PORT->DINR & (1UL << _BUTTON1_))																						
#define	BUTTON2_IN	(BUTTON2_PORT->DINR & (1UL << _BUTTON2_))
#define	BUTTON3_IN	(BUTTON3_PORT->DINR & (1UL << _BUTTON3_))
#define	BUTTON4_IN	(BUTTON4_PORT->DINR & (1UL << _BUTTON4_))


#define  BUTTON_CONSISTENCY_DURATION   6
#define  BUTTON_REPEAT1_DURATION       (600 / BUTTON_CONSISTENCY_DURATION)
#define  BUTTON_REPEAT2_DURATION       (150 / BUTTON_CONSISTENCY_DURATION)

void 	button_IO_configure(void);
bool 	scan_button_IO(void);
u8		load_button_IO(void);
u8 	get_button_status(void);

#endif /* _BUTTON_H_ */
